/******************************************************************************/
/* Vector Redirection FILE FOR MSPBoot BOOTLOADER USING MSP430G2553  */
/* File generated with MSPBootVecRedGen.pl on 08-01-2017 */
/*----------------------------------------------------------------------------*/

//
// Include files
//
#include "msp430.h"
#include "TI_MSPBoot_Common.h"
#include "TI_MSPBoot_AppMgr.h"

//
//  External variables from linker file
//
extern uint16_t _Appl_Proxy_Vector_Start[];  /* Proxy table address */
//extern __interrupt void Timer_A (void);
//
//  Macros and definitions
//
/* Value written to unused vectors */
#define UNUSED                  (0x3FFF)       
/*! Macro used to calculate address of vector in Application Proxy Table */
#define APP_PROXY_VECTOR(x)     ((uint16_t)&_Appl_Proxy_Vector_Start[x*2])

//
//  Constant table
//
/*! MSPBoot Vector Table: It's fixed since it can't be erased and modified.
 *  Points to a proxy vector table in Application area*/
#pragma DATA_SECTION(Vector_Table, ".BOOT_VECTOR_TABLE")
#pragma RETAIN(Vector_Table)
const uint16_t Vector_Table[] =
{
    /* APP_PROXY_VECTOR(0),                        // FFE0 =  TRAPINT
     UNUSED,                                     // FFE2 = unused
     APP_PROXY_VECTOR(1),                        // FFE4 =  PORT1       
     APP_PROXY_VECTOR(2),                        // FFE6 =  PORT2       
     UNUSED,                                     // FFE8 = unused
     APP_PROXY_VECTOR(3),                        // FFEA =  ADC10       
     APP_PROXY_VECTOR(4),                        // FFEC =  USCIAB0TX   
     APP_PROXY_VECTOR(5),                        // FFEE =  USCIAB0RX   
     APP_PROXY_VECTOR(6),                        // FFF0 =  TIMER0_A1   
     APP_PROXY_VECTOR(7),                        // FFF2 =  TIMER0_A0   
     APP_PROXY_VECTOR(8),                        // FFF4 =  WDT         
     APP_PROXY_VECTOR(9),                        // FFF6 =  COMPARATORA  
     APP_PROXY_VECTOR(10),                        // FFF8 =  TIMER1_A1   
     APP_PROXY_VECTOR(11),                        // FFFA =  TIMER1_A0   
     APP_PROXY_VECTOR(12),  */                      // FFFC =  NMI

		        UNUSED,                    //: origin = 0xFFC0, length = 0x0002
				UNUSED,                   //: origin = 0xFFC2, length = 0x0002
				UNUSED,                   //: origin = 0xFFC4, length = 0x0002
				UNUSED,                   //: origin = 0xFFC6, length = 0x0002
				UNUSED,                   //: origin = 0xFFC8, length = 0x0002
				UNUSED,                   //: origin = 0xFFCA, length = 0x0002
				UNUSED,                   //: origin = 0xFFCC, length = 0x0002
				UNUSED,                   //: origin = 0xFFCE, length = 0x0002
				UNUSED,                   //: origin = 0xFFD0, length = 0x0002
				UNUSED,                   //: origin = 0xFFD2, length = 0x0002
				UNUSED,                   //: origin = 0xFFD4, length = 0x0002
				UNUSED,                   //: origin = 0xFFD6, length = 0x0002
				UNUSED,                   //: origin = 0xFFD8, length = 0x0002
				UNUSED,                   //: origin = 0xFFDA, length = 0x0002
				UNUSED,                   //: origin = 0xFFDC, length = 0x0002
				APP_PROXY_VECTOR(0),                   //: origin = 0xFFDE, length = 0x0002  DMA
				APP_PROXY_VECTOR(1),                   //: origin = 0xFFE0, length = 0x0002  Basic timer/RTC
				APP_PROXY_VECTOR(2),                   //: origin = 0xFFE2, length = 0x0002  PORT P2
				APP_PROXY_VECTOR(3),                   //: origin = 0xFFE4, length = 0x0002  USCI_A1/B1 Transmit
				APP_PROXY_VECTOR(4),                   //: origin = 0xFFE6, length = 0x0002  USCI_A1/B1 Receive
				APP_PROXY_VECTOR(5),                   //: origin = 0xFFE8, length = 0x0002  PORT 1
				APP_PROXY_VECTOR(6),                   //: origin = 0xFFEA, length = 0x0002  Timer_A3
				APP_PROXY_VECTOR(7),                             //: origin = 0xFFEC, length = 0x0002  Timer_A3
				APP_PROXY_VECTOR(8),                   //: origin = 0xFFEE, length = 0x0002  SD16_A
				APP_PROXY_VECTOR(9),                   //: origin = 0xFFF0, length = 0x0002  USCI_A0/B0 Transmit
				APP_PROXY_VECTOR(10),                   //: origin = 0xFFF2, length = 0x0002 USCI_A0/B0 Receive
				APP_PROXY_VECTOR(11),                   //: origin = 0xFFF4, length = 0x0002 Watchdog Timer
				APP_PROXY_VECTOR(12),                   //: origin = 0xFFF6, length = 0x0002 Comparator_A
				APP_PROXY_VECTOR(13),                   //: origin = 0xFFF8, length = 0x0002 Timer_B3
				APP_PROXY_VECTOR(14),                   //: origin = 0xFFFA, length = 0x0002 Timer_B3
				APP_PROXY_VECTOR(15),                   //: origin = 0xFFFC, length = 0x0002 NMI
};
